
#include "g_local.h"

#define Function(f) {#f, f}

mmove_t mmove_reloc;

field_t fields[] = {
	{"classname", FOFS(classname), F_LSTRING},
	{"model", FOFS(model), F_LSTRING},
	{"spawnflags", FOFS(spawnflags), F_INT},
	{"speed", FOFS(speed), F_FLOAT},
	{"accel", FOFS(accel), F_FLOAT},
	{"decel", FOFS(decel), F_FLOAT},
	{"target", FOFS(target), F_LSTRING},
	{"targetname", FOFS(targetname), F_LSTRING},
	{"pathtarget", FOFS(pathtarget), F_LSTRING},
	{"deathtarget", FOFS(deathtarget), F_LSTRING},
	{"killtarget", FOFS(killtarget), F_LSTRING},
	{"combattarget", FOFS(combattarget), F_LSTRING},
	{"message", FOFS(message), F_LSTRING},
	{"team", FOFS(team), F_LSTRING},
	{"wait", FOFS(wait), F_FLOAT},
	{"delay", FOFS(delay), F_FLOAT},
	{"random", FOFS(random), F_FLOAT},
	{"move_origin", FOFS(move_origin), F_VECTOR},
	{"move_angles", FOFS(move_angles), F_VECTOR},
	{"style", FOFS(style), F_INT},
	{"count", FOFS(count), F_INT},
	{"health", FOFS(health), F_INT},
	{"sounds", FOFS(sounds), F_INT},

	{"light", FOFS(light_level), F_INT},	// Ridah, used by model lighting code
	{"_color", FOFS(rotate), F_VECTOR},		// Ridah, used by model lighting code
	{"radius", FOFS(dmg_radius), F_VECTOR},		// Ridah, used by model lighting code

	{"dmg", FOFS(dmg), F_INT},
	{"mass", FOFS(mass), F_INT},
	{"volume", FOFS(volume), F_FLOAT},
	{"attenuation", FOFS(attenuation), F_FLOAT},
	{"map", FOFS(map), F_LSTRING},
	{"origin", FOFS(s.origin), F_VECTOR},
	{"angles", FOFS(s.angles), F_VECTOR},
	{"angle", FOFS(s.angles), F_ANGLEHACK},

	{"objectbounds_filename1", FOFS(s.model_parts[0].objectbounds_filename), F_LSTRING},
	{"objectbounds_filename2", FOFS(s.model_parts[1].objectbounds_filename), F_LSTRING},
	{"objectbounds_filename3", FOFS(s.model_parts[2].objectbounds_filename), F_LSTRING},
	{"objectbounds_filename4", FOFS(s.model_parts[3].objectbounds_filename), F_LSTRING},
	{"objectbounds_filename5", FOFS(s.model_parts[4].objectbounds_filename), F_LSTRING},
	{"objectbounds_filename6", FOFS(s.model_parts[5].objectbounds_filename), F_LSTRING},
	{"objectbounds_filename7", FOFS(s.model_parts[6].objectbounds_filename), F_LSTRING},
	{"objectbounds_filename8", FOFS(s.model_parts[7].objectbounds_filename), F_LSTRING},

// JOSEPH 19-MAR-99
	{"rotate", FOFS(rotate), F_VECTOR},
	{"duration", FOFS(duration), F_FLOAT},
	{"alphalevel", FOFS(alphalevel), F_INT},
	{"fxdensity", FOFS(fxdensity), F_INT},
	{"healspeed", FOFS(healspeed), F_INT}, 
	{"deadticks", FOFS(deadticks), F_INT}, 
	{"missteam", FOFS(missteam), F_INT}, 
	{"misstime", FOFS(misstime), F_INT}, 
	{"cameraangle", FOFS(cameraangle), F_VECTOR}, 
	{"cameraorigin", FOFS(cameraorigin), F_VECTOR}, 
	{"cameravel", FOFS(cameravel), F_VECTOR},
	{"cameravelrel", FOFS(cameravelrel), F_VECTOR},
	{"debugprint", FOFS(debugprint), F_INT},
	{"target2", FOFS(target2), F_LSTRING},
	{"localteam", FOFS(localteam), F_LSTRING},
	{"reactdelay", FOFS(reactdelay), F_FLOAT}, 
	{"currentcash", FOFS(currentcash), F_INT},
	{"type", FOFS(type), F_LSTRING},
	{"head", FOFS(head), F_INT},
	{"key", FOFS(key), F_INT},
	{"target2_ent", FOFS(target2_ent), F_EDICT},
	{"missent", FOFS(missent), F_EDICT},
	{"handle", FOFS(handle), F_EDICT},
	{"handle2", FOFS(handle2), F_EDICT},
	{"save_self", FOFS(save_self), F_EDICT},
	{"save_other", FOFS(save_other), F_EDICT},
	{"deadticks", FOFS(deadticks), F_INT},
	{"thudsnd", FOFS(thudsnd), F_INT},
	{"head", FOFS(head), F_INT},
	{"firetype", FOFS(firetype), F_INT},
	{"thudsurf", FOFS(thudsurf), F_INT},
	{"lightit", FOFS(lightit), F_INT},
	{"option", FOFS(option), F_INT},
	{"noshadow", FOFS(noshadow), F_INT},
// END JOSEPH

	{"acc", FOFS (acc), F_INT},
	{"cal", FOFS (cal), F_INT},

	// Ridah, new stuff

	{"cast_group", FOFS(cast_group), F_INT},
	{"skin", FOFS(skin), F_INT},
	{"moral", FOFS(moral), F_INT},
	{"guard_radius", FOFS(guard_radius), F_INT},
	{"guard_target", FOFS(guard_target), F_LSTRING},
	{"name", FOFS(name), F_LSTRING},
	{"episode", FOFS(count), F_INT},				// used by worldspawn
	{"scriptname", FOFS(scriptname), F_LSTRING},

	{"onfireent", FOFS(onfireent), F_EDICT},
	{"leader", FOFS(leader), F_EDICT},
	{"leader_target", FOFS(leader_target), F_LSTRING},
	{"last_goal", FOFS(last_goal), F_EDICT},

	{"order", FOFS(order), F_INT},
	{"order_timestamp", FOFS(order_timestamp), F_FLOAT},
	{"moveout_ent", FOFS(moveout_ent), F_EDICT},
	{"character_index", FOFS(character_index), F_INT},
	{"last_talk_time", FOFS(last_talk_time), F_FLOAT},
	{"profanity_level", FOFS(profanity_level), F_INT},
	{"guard_ent", FOFS(guard_ent), F_EDICT},
	{"sight_target", FOFS(sight_target), F_LSTRING},
	{"goal_ent", FOFS(goal_ent), F_EDICT},
	{"combat_goalent", FOFS(combat_goalent), F_EDICT},
	{"cover_ent", FOFS(cover_ent), F_EDICT},
	
	{"episode_flags", FOFS(episode_flags), F_INT},

	{"name_index", FOFS(name_index), F_INT},
	{"last_territory_touched", FOFS(last_territory_touched), F_EDICT},
	{"response_ent", FOFS(response_ent), F_EDICT},
	{"last_response_time", FOFS(last_response_time), F_FLOAT},
	{"last_response", FOFS(last_response), F_INT},

	{"start_ent", FOFS(start_ent), F_EDICT},
	{"holdpos_ent", FOFS(holdpos_ent), F_EDICT},

	{"next_combattarget", FOFS(next_combattarget), F_LSTRING},

	{"activate_flags", FOFS(activate_flags), F_INT},
	{"biketime", FOFS(biketime), F_FLOAT},
	{"bikestate", FOFS(bikestate), F_INT},

	{"vehicle_index", FOFS(vehicle_index), F_INT},

	{"art_skins", FOFS(art_skins), F_LSTRING},

	{"aiflags", FOFS(cast_info.aiflags), F_INT},

	{"gun_noise_delay", FOFS(gun_noise_delay), F_FLOAT},

	{"scale", FOFS(cast_info.scale), F_FLOAT},

	{"voice_pitch", FOFS(voice_pitch), F_FLOAT},

	{"health_threshold", FOFS(health_threshold), F_INT},
	{"health_target", FOFS(health_target), F_LSTRING},
	{"health_threshold2", FOFS(health_threshold2), F_INT},
	{"health_target2", FOFS(health_target2), F_LSTRING},
	{"health_threshold3", FOFS(health_threshold3), F_INT},
	{"health_target3", FOFS(health_target3), F_LSTRING},
	// Ridah, done.

	
	{"goalentity", FOFS(goalentity), F_EDICT, FFL_NOSPAWN},
	{"movetarget", FOFS(movetarget), F_EDICT, FFL_NOSPAWN},
	{"enemy", FOFS(enemy), F_EDICT, FFL_NOSPAWN},
	{"oldenemy", FOFS(oldenemy), F_EDICT, FFL_NOSPAWN},
	{"activator", FOFS(activator), F_EDICT, FFL_NOSPAWN},
	{"groundentity", FOFS(groundentity), F_EDICT, FFL_NOSPAWN},
	{"teamchain", FOFS(teamchain), F_EDICT, FFL_NOSPAWN},
	{"teammaster", FOFS(teammaster), F_EDICT, FFL_NOSPAWN},
	{"owner", FOFS(owner), F_EDICT, FFL_NOSPAWN},
	{"mynoise", FOFS(mynoise), F_EDICT, FFL_NOSPAWN},
	{"mynoise2", FOFS(mynoise2), F_EDICT, FFL_NOSPAWN},
	{"target_ent", FOFS(target_ent), F_EDICT, FFL_NOSPAWN},
	{"chain", FOFS(chain), F_EDICT, FFL_NOSPAWN},

	{"prethink", FOFS(prethink), F_FUNCTION, FFL_NOSPAWN},
	{"think", FOFS(think), F_FUNCTION, FFL_NOSPAWN},
	{"blocked", FOFS(blocked), F_FUNCTION, FFL_NOSPAWN},
	{"touch", FOFS(touch), F_FUNCTION, FFL_NOSPAWN},
	{"use", FOFS(use), F_FUNCTION, FFL_NOSPAWN},
	{"pain", FOFS(pain), F_FUNCTION, FFL_NOSPAWN},
	{"die", FOFS(die), F_FUNCTION, FFL_NOSPAWN},

	{"idle", FOFS(cast_info.idle), F_FUNCTION, FFL_NOSPAWN},
	{"search", FOFS(cast_info.search), F_FUNCTION, FFL_NOSPAWN},
	{"dodge", FOFS(cast_info.dodge), F_FUNCTION, FFL_NOSPAWN},
	{"attack", FOFS(cast_info.attack), F_FUNCTION, FFL_NOSPAWN},
	{"long_attack", FOFS(cast_info.long_attack), F_FUNCTION, FFL_NOSPAWN},
	{"sight", FOFS(cast_info.sight), F_FUNCTION, FFL_NOSPAWN},
	{"duck", FOFS(cast_info.duck), F_FUNCTION, FFL_NOSPAWN},
	{"talk", FOFS(cast_info.talk), F_FUNCTION, FFL_NOSPAWN},
	{"avoid", FOFS(cast_info.avoid), F_FUNCTION, FFL_NOSPAWN},
	
	{"backoff", FOFS(cast_info.backoff), F_FUNCTION, FFL_NOSPAWN},
	
	{"catch_fire", FOFS(cast_info.catch_fire), F_FUNCTION, FFL_NOSPAWN},
	{"checkattack", FOFS(cast_info.checkattack), F_FUNCTION, FFL_NOSPAWN},
	{"currentmove", FOFS(cast_info.currentmove), F_MMOVE, FFL_NOSPAWN},
	
	{"oldcurrentmove", FOFS(cast_info.oldcurrentmove), F_MMOVE, FFL_NOSPAWN},

	{"move_stand", FOFS(cast_info.move_stand), F_MMOVE, FFL_NOSPAWN},
	{"move_crstand", FOFS(cast_info.move_crstand), F_MMOVE, FFL_NOSPAWN},
	{"move_run", FOFS(cast_info.move_run), F_MMOVE, FFL_NOSPAWN},
	{"move_runwalk", FOFS(cast_info.move_runwalk), F_MMOVE, FFL_NOSPAWN},
	{"move_crwalk", FOFS(cast_info.move_crwalk), F_MMOVE, FFL_NOSPAWN},
	{"move_jump", FOFS(cast_info.move_jump), F_MMOVE, FFL_NOSPAWN},
	{"move_crouch_down", FOFS(cast_info.move_crouch_down), F_MMOVE, FFL_NOSPAWN},
	{"move_stand_up", FOFS(cast_info.move_stand_up), F_MMOVE, FFL_NOSPAWN},
	{"move_avoid_walk", FOFS(cast_info.move_avoid_walk), F_MMOVE, FFL_NOSPAWN},
	{"move_avoid_run", FOFS(cast_info.move_avoid_run), F_MMOVE, FFL_NOSPAWN},
	{"move_avoid_reverse_walk", FOFS(cast_info.move_avoid_reverse_walk), F_MMOVE, FFL_NOSPAWN},
	{"move_avoid_reverse_run", FOFS(cast_info.move_avoid_reverse_run), F_MMOVE, FFL_NOSPAWN},
	{"move_avoid_crwalk", FOFS(cast_info.move_avoid_crwalk), F_MMOVE, FFL_NOSPAWN},
	{"move_lside_step", FOFS(cast_info.move_lside_step), F_MMOVE, FFL_NOSPAWN},
	{"move_rside_step", FOFS(cast_info.move_rside_step), F_MMOVE, FFL_NOSPAWN},
	{"move_start_climb", FOFS(cast_info.move_start_climb), F_MMOVE, FFL_NOSPAWN},
	{"move_end_climb", FOFS(cast_info.move_end_climb), F_MMOVE, FFL_NOSPAWN},
	{"move_evade", FOFS(cast_info.move_evade), F_MMOVE, FFL_NOSPAWN},
	{"move_stand_evade", FOFS(cast_info.move_stand_evade), F_MMOVE, FFL_NOSPAWN},
	

	{"avoid_ent", FOFS(cast_info.avoid_ent), F_EDICT, FFL_NOSPAWN},
	{"talk_ent", FOFS(cast_info.talk_ent), F_EDICT, FFL_NOSPAWN},

	{"friend_memory", FOFS(cast_info.friend_memory), F_CAST_MEMORY, FFL_NOSPAWN},
	{"neutral_memory", FOFS(cast_info.neutral_memory), F_CAST_MEMORY, FFL_NOSPAWN},
	{"enemy_memory", FOFS(cast_info.enemy_memory), F_CAST_MEMORY, FFL_NOSPAWN},

	{"endfunc", FOFS(moveinfo.endfunc), F_FUNCTION, FFL_NOSPAWN},


	// temp spawn vars -- only valid when the spawn function is called
	{"lip", STOFS(lip), F_INT, FFL_SPAWNTEMP},
	{"distance", STOFS(distance), F_INT, FFL_SPAWNTEMP},
	{"height", STOFS(height), F_INT, FFL_SPAWNTEMP},
	{"noise", STOFS(noise), F_LSTRING, FFL_SPAWNTEMP},
	{"pausetime", STOFS(pausetime), F_FLOAT, FFL_SPAWNTEMP},
	{"item", STOFS(item), F_LSTRING, FFL_SPAWNTEMP},

//need for item field in edict struct, FFL_SPAWNTEMP item will be skipped on saves
	{"item", FOFS(item), F_ITEM},

	{"gravity", STOFS(gravity), F_LSTRING, FFL_SPAWNTEMP},
	{"sky", STOFS(sky), F_LSTRING, FFL_SPAWNTEMP},
	{"minyaw", STOFS(minyaw), F_FLOAT, FFL_SPAWNTEMP},
	{"maxyaw", STOFS(maxyaw), F_FLOAT, FFL_SPAWNTEMP},
	{"minpitch", STOFS(minpitch), F_FLOAT, FFL_SPAWNTEMP},
	{"maxpitch", STOFS(maxpitch), F_FLOAT, FFL_SPAWNTEMP},
	{"nextmap", STOFS(nextmap), F_LSTRING, FFL_SPAWNTEMP},
	{"fogdensity", STOFS(fogdensity), F_FLOAT, FFL_SPAWNTEMP}, 
	{"fogval", STOFS(fogval), F_VECTOR, FFL_SPAWNTEMP},

	{"fogdensity2", STOFS(fogdensity2), F_FLOAT, FFL_SPAWNTEMP}, 
	{"fogval2", STOFS(fogval2), F_VECTOR, FFL_SPAWNTEMP},


	{0, 0, 0, 0}

};

field_t		levelfields[] =
{
	{"changemap", LLOFS(changemap), F_LSTRING},
                   
	{"sight_client", LLOFS(sight_client), F_EDICT},
	{"sight_entity", LLOFS(sight_entity), F_EDICT},
	{"sound_entity", LLOFS(sound_entity), F_EDICT},
	{"sound2_entity", LLOFS(sound2_entity), F_EDICT},

	{"characters", LLOFS(characters), F_IGNORE},

	{NULL, 0, F_INT}
};

field_t		clientfields[] =
{
	{"pers.weapon", CLOFS(pers.weapon), F_ITEM},
	{"pers.holsteredweapon", CLOFS(pers.holsteredweapon), F_ITEM},
	{"pers.lastweapon", CLOFS(pers.lastweapon), F_ITEM},
	{"newweapon", CLOFS(newweapon), F_ITEM},
	{NULL, 0, F_INT}
};

field_t		castmemoryfields[] =
{
	{"response", CMOFS(response), F_FUNCTION},
	{"next", CMOFS(next), F_CAST_MEMORY},
	{"prev", CMOFS(prev), F_CAST_MEMORY},

	{NULL, 0, F_INT}
};

/*
============
InitGame

This will be called when the dll is first loaded, which
only happens when a new game is started or a save game
is loaded.
============
*/
void InitGame (void)
{
	gi.dprintf ("==== InitGame ====\n");

	gun_x = gi.cvar ("gun_x", "0", 0);
	gun_y = gi.cvar ("gun_y", "0", 0);
	gun_z = gi.cvar ("gun_z", "0", 0);

	//FIXME: sv_ prefix is wrong for these
	sv_rollspeed = gi.cvar ("sv_rollspeed", "200", 0);
	sv_rollangle = gi.cvar ("sv_rollangle", "0", 0);
	sv_maxvelocity = gi.cvar ("sv_maxvelocity", "2000", 0);
	sv_gravity = gi.cvar ("sv_gravity", "800", 0);

	// noset vars
	dedicated = gi.cvar ("dedicated", "0", CVAR_NOSET);

	// latched vars
	sv_cheats = gi.cvar ("cheats", "0", CVAR_SERVERINFO|CVAR_LATCH);
	gi.cvar ("gamename", GAMEVERSION , CVAR_SERVERINFO | CVAR_LATCH);
	gi.cvar ("gamedate", __DATE__ , CVAR_SERVERINFO | CVAR_LATCH);

	maxclients = gi.cvar ("maxclients", "4", CVAR_SERVERINFO | CVAR_LATCH);
	deathmatch = gi.cvar ("deathmatch", "0", CVAR_LATCH);
	coop = gi.cvar ("coop", "0", CVAR_LATCH);
	skill = gi.cvar ("skill", "1", CVAR_LATCH);

	// JOSEPH 16-OCT-98
	maxentities = gi.cvar ("maxentities", /*"1024"*/"2048", CVAR_LATCH);
//******************************************************************************************
// WCJ - DM MUTATOR VARIABLES
//******************************************************************************************
//Kill Modifier - how many frags you gain/lose for killing the enemy
//******************************************************************************************

	KillModifier = gi.cvar ("KillModifier", "1", CVAR_SERVERINFO | CVAR_LATCH);
	
// Check value for KillModifier	 - MaxValue is 999 points for a kill - Minimum is -999 points
	if (KillModifier->value > 999)
		KillModifier->value = 999;

	if (KillModifier->value < -999)
		KillModifier->value = -999;

//******************************************************************************************
//SuicideModifier - how many frags you lose/gain for commiting suicide
//******************************************************************************************

	SuicideModifier = gi.cvar ("SuicideModifier", "1", CVAR_SERVERINFO | CVAR_LATCH);

// Check value for SuicideModifier - MaxValue is 999 points for a kill - Minimum is -999 points

	if (SuicideModifier->value > 999)
		SuicideModifier->value = 999;

	if (SuicideModifier->value < -999)
		SuicideModifier->value = -999;

//******************************************************************************************
//FragLossModifier - how many frags you lose when you are killed by someone else
//******************************************************************************************

	FragLossModifier = gi.cvar ("FragLossModifier", "0", CVAR_SERVERINFO | CVAR_LATCH);

// Check value for SuicideModifier - MaxValue is 999 points for a kill - Minimum is -999 points

	if (FragLossModifier->value > 999)
		FragLossModifier->value = 999;

	if (FragLossModifier->value < -999)
		FragLossModifier->value = -999;

//******************************************************************************************
//StartingHealth - how much health you have when you start a game
//******************************************************************************************

	StartHealth = gi.cvar ("StartHealth", "100", CVAR_SERVERINFO | CVAR_LATCH);

// Check value for StartingHealth - MaxValue is 999 points - Minimum is 1 health point

	if (StartHealth->value > 999)
		StartHealth->value = 999;

	if (StartHealth->value < 1)
		StartHealth->value = 1;

//******************************************************************************************
//MaxHealth - how much health you can have while playing
//******************************************************************************************

	MaxHealth = gi.cvar ("MaxHealth", "100", CVAR_SERVERINFO | CVAR_LATCH);

// Check value for MaxHealth - MaxValue is 999 points - Minimum is 1 health point

	if (MaxHealth->value > 999)
		MaxHealth->value = 999;

	if (MaxHealth->value < 1)
		MaxHealth->value = 1;

//******************************************************************************************
//RespawnInvulnerability - how much invulnerability you get when you start a game
//******************************************************************************************

	RespawnInvul = gi.cvar ("RespawnInvul", "0", CVAR_SERVERINFO | CVAR_LATCH);

// Check value for Respawn Invulnerability - MaxValue is 999 seconds - Minimum is 0 seconds
// Multiplied by 10 as there are 10 frames per second to the timer

	if (RespawnInvul->value > 999)
		RespawnInvul->value = (999);

	if (RespawnInvul->value < 1)
		RespawnInvul->value = 0;
	else
		RespawnInvul->value = (RespawnInvul->value * 10);

//******************************************************************************************
//MaxBullets - how many bullets you can carry
//******************************************************************************************

	MaxBullets = gi.cvar ("MaxBullets", "250", CVAR_SERVERINFO | CVAR_LATCH);

// Check value for MaxBullets - MaxValue is 999 points - Minimum is 0 

	if (MaxBullets->value > 999)
		MaxBullets->value = 999;

	if (MaxBullets->value < 0)
		MaxBullets->value = 0;


//******************************************************************************************
//MaxShells - how many shotgun shells you can carry
//******************************************************************************************

	MaxShells = gi.cvar ("MaxShells", "96", CVAR_SERVERINFO | CVAR_LATCH);

// Check value for MaxShells - MaxValue is 999 points - Minimum is 0 

	if (MaxShells->value > 999)
		MaxShells->value = 999;

	if (MaxShells->value < 0)
		MaxShells->value = 0;

//******************************************************************************************
//MaxGrenades - how many Grenades you can carry
//******************************************************************************************

	MaxGrenades = gi.cvar ("MaxGrenades", "12", CVAR_SERVERINFO | CVAR_LATCH);

// Check value for MaxGrenades - MaxValue is 999 points - Minimum is 0 

	if (MaxGrenades->value > 999)
		MaxGrenades->value = 999;

	if (MaxGrenades->value < 0)
		MaxGrenades->value = 0;

//******************************************************************************************
//MaxRockets - how many rockets you can carry
//******************************************************************************************

	MaxRockets = gi.cvar ("MaxRockets", "25", CVAR_SERVERINFO | CVAR_LATCH);

// Check value for MaxRockets - MaxValue is 999 points - Minimum is 0 

	if (MaxRockets->value > 999)
		MaxRockets->value = 999;

	if (MaxRockets->value < 0)
		MaxRockets->value = 0;


//******************************************************************************************
//MaxGas - how much gas (cannisters) you can carry
//******************************************************************************************

	MaxGas = gi.cvar ("MaxGas", "200", CVAR_SERVERINFO | CVAR_LATCH);

// Check value for MaxGas - MaxValue is 999 points - Minimum is 0 

	if (MaxGas->value > 999)
		MaxGas->value = 999;

	if (MaxGas->value < 0)
		MaxGas->value = 0;

//******************************************************************************************
//Max308 - how much HMG ammo you can carry
//******************************************************************************************

	Max308 = gi.cvar ("Max308", "90", CVAR_SERVERINFO | CVAR_LATCH);

// Check value for Max308 - MaxValue is 999 points - Minimum is 0 

	if (Max308->value > 999)
		Max308->value = 999;

	if (Max308->value < 0)
		Max308->value = 0;


//******************************************************************************************
//Weapon Clip sizes - how much HMG ammo you can carry
//******************************************************************************************

PistolClipSize = gi.cvar ("PistolClipSize", "10", CVAR_SERVERINFO);	
ShotgunClipSize = gi.cvar ("ShotgunClipSize", "8", CVAR_SERVERINFO);	
TommyClipSize = gi.cvar ("TommyClipSize", "50", CVAR_SERVERINFO);	
HMGClipSize = gi.cvar ("HMGClipSize", "30", CVAR_SERVERINFO);	
GrenadeClipSize = gi.cvar ("GrenadeClipSize", "3", CVAR_SERVERINFO);	
RocketClipSize = gi.cvar ("RocketClipSize", "5", CVAR_SERVERINFO);	





//******************************************************************************************
//StartHelmet  - If you start with Helmet Armour and how much
//******************************************************************************************

	StartHelmet = gi.cvar ("StartHelmet", "0", CVAR_SERVERINFO | CVAR_LATCH);

// Check value for Helmet Armour - MaxValue is 999 points - Minimum is 0 

	if (StartHelmet->value > 999)
		StartHelmet->value = 999;

	if (StartHelmet->value < 0)
		StartHelmet->value = 0;

//******************************************************************************************
//StartBody  - If you start with Body Armour and how much
//******************************************************************************************

	StartBody = gi.cvar ("StartBody", "0", CVAR_SERVERINFO | CVAR_LATCH);

// Check value for Body Armour - MaxValue is 999 points - Minimum is 0 

	if (StartBody->value > 999)
		StartBody->value = 999;

	if (StartBody->value < 0)
		StartBody->value = 0;

//******************************************************************************************
//StartLegs  - If you start with Leg Armour and how much
//******************************************************************************************

	StartLeg = gi.cvar ("StartLeg", "0", CVAR_SERVERINFO | CVAR_LATCH);

// Check value for Armour - MaxValue is 999 points - Minimum is 0 

	if (StartLeg->value > 999)
		StartLeg->value = 999;

	if (StartLeg->value < 0)
		StartLeg->value = 0;

//******************************************************************************************
//MaxHelmet  - The Maximum amount of helmet armour you can have
//******************************************************************************************

	MaxHelmet = gi.cvar ("MaxHelmet", "100", CVAR_SERVERINFO | CVAR_LATCH);

// Check value for Max Helmet Armour - MaxValue is 999 points - Minimum is 0 

	if (MaxHelmet->value > 999)
		MaxHelmet->value = 999;

	if (MaxHelmet->value < 0)
		MaxHelmet->value = 0;

//******************************************************************************************
//MaxBody  - The maximum amount of body armour you can have
//******************************************************************************************

	MaxBody = gi.cvar ("MaxBody", "100", CVAR_SERVERINFO | CVAR_LATCH);

// Check value for Body Armour - MaxValue is 999 points - Minimum is 0 

	if (MaxBody->value > 999)
		MaxBody->value = 999;

	if (MaxBody->value < 0)
		MaxBody->value = 0;

//******************************************************************************************
//MaxLegs  - The maximum amount of Leg armour you can have
//******************************************************************************************

	MaxLeg = gi.cvar ("MaxLeg", "100", CVAR_SERVERINFO | CVAR_LATCH);

// Check value for Leg Armour - MaxValue is 999 points - Minimum is 0 

	if (MaxLeg->value > 999)
		MaxLeg->value = 999;

	if (MaxLeg->value < 0)
		MaxLeg->value = 0;

//******************************************************************************************
//StartMagMod  - If you start with the magnum pistol mod
//******************************************************************************************

	StartMagMod = gi.cvar ("StartMagMod", "0", CVAR_SERVERINFO | CVAR_LATCH);

// Check value to see whether to include Magnum at start up - 0 is off - any other number is on

	if (StartMagMod->value > 0)
		StartMagMod->value = 1;

	else
		StartMagMod->value = 0;

//******************************************************************************************
//StartPistolROF  - If you start with the pistol Rate of Fire mod
//******************************************************************************************

	StartPistolROF = gi.cvar ("StartPistolROF", "0", CVAR_SERVERINFO | CVAR_LATCH);

// Check value to see whether to include ROF mod on start up - 0 is off - any other number is on

	if (StartPistolROF->value < 1)
		StartPistolROF->value = 0;

	else
		StartPistolROF->value = 1;

//******************************************************************************************
//StartPistolReload  - If you start with the pistol Quick Reload mod
//******************************************************************************************

	StartPistolReload = gi.cvar ("StartPistolReload", "0", CVAR_SERVERINFO | CVAR_LATCH);

// Check value to see whether to include ROF mod on start up - 0 is off - any other number is on

	if (StartPistolReload->value < 1)
		StartPistolReload->value = 0;

	else
		StartPistolReload->value = 1;

//******************************************************************************************
//StartSilencer  - If you start with the silencer mod
//******************************************************************************************

	StartSilencer = gi.cvar ("StartSilencer", "0", CVAR_SERVERINFO | CVAR_LATCH);

// Check value to see whether to include Silencer mod on start up - 0 is off - any other number is on

	if (StartSilencer->value < 1)
		StartSilencer->value = 0;

	else
		StartSilencer->value = 1;


//******************************************************************************************
//StartCoolingClip  - If you start with the silencer mod
//******************************************************************************************

	StartCoolingClip = gi.cvar ("StartCoolingClip", "0", CVAR_SERVERINFO | CVAR_LATCH);

// Check value to see whether to include HMG Cooling clip mod on start up - 0 is off - any other number is on

	if (StartCoolingClip->value < 1)
		StartCoolingClip->value = 0;

	else
		StartCoolingClip->value = 1;

//******************************************************************************************
//AntiGrav  - If antigrav boots are allowed
//******************************************************************************************

	AntiGrav = gi.cvar ("AntiGrav", "0", CVAR_SERVERINFO | CVAR_LATCH);

// Check value to see whether to include HMG Cooling clip mod on start up - 0 is off - any other number is on

	if (AntiGrav->value < 1)
		AntiGrav->value = 0;

	else if (AntiGrav->value > 0)
		AntiGrav->value = 1;

//******************************************************************************************
//BootGravity - What the gravity value is for when the boots are on
//******************************************************************************************

	BootGravity = gi.cvar ("BootGravity", "600", CVAR_SERVERINFO | CVAR_LATCH);

// Check value to see whether to include HMG Cooling clip mod on start up - 0 is off - any other number is on

	if (BootGravity->value < 1)
		BootGravity->value = 1;

	else if (BootGravity->value > 2000)
		BootGravity->value= 2000;

//******************************************************************************************
//Flashbangs - Whether to allow flashbangs in the game
//******************************************************************************************

	Flashbangs = gi.cvar ("Flashbangs", "0", CVAR_SERVERINFO | CVAR_LATCH);

// Check value to see whether to include HMG Cooling clip mod on start up - 0 is off - any other number is on

	if (Flashbangs->value < 0)
		Flashbangs->value = 0;

	else if (Flashbangs->value > 1)
		Flashbangs->value= 1;


//******************************************************************************************
//StartWithFlashlight - If you start with the torch
//******************************************************************************************

	StartWithFlashlight= gi.cvar ("StartWithFlashlight", "0", CVAR_SERVERINFO | CVAR_LATCH);

	if (StartWithFlashlight->value < 1)
		StartWithFlashlight->value = 0;

	else
		StartWithFlashlight->value = 1;
//******************************************************************************************
//Darkmatch- Whether the lights are off or on
//******************************************************************************************

	DarkMatch= gi.cvar ("DarkMatch", "0", CVAR_SERVERINFO | CVAR_LATCH);

	if (DarkMatch->value == 1)
		DarkMatch->value = 1;

	else
		DarkMatch->value = 0;
//******************************************************************************************
//StartCrowbar  - If you start with the Crowbar
//******************************************************************************************

	StartCrowbar = gi.cvar ("StartCrowbar", "0", CVAR_SERVERINFO | CVAR_LATCH);

// Check value to see whether you have the Crowbar on starting
	if (StartCrowbar->value < 1)
		StartCrowbar->value = 0;
	else
		StartCrowbar->value = 1;


//******************************************************************************************
//StartPistol - If you start with the Pistol
//******************************************************************************************

	StartPistol = gi.cvar ("StartPistol", "1", CVAR_SERVERINFO | CVAR_LATCH);

	if (StartPistol->value < 1)
		StartPistol->value = 0;
	else
		StartPistol->value = 1;


//******************************************************************************************
//StartShotgun - If you start with the Shotgun
//******************************************************************************************

	StartShotgun = gi.cvar ("StartShotgun", "0", CVAR_SERVERINFO | CVAR_LATCH);

	if (StartShotgun->value < 1)
		StartShotgun->value = 0;
	else
		StartShotgun->value = 1;

//******************************************************************************************
//StartTommyGun - If you start with the TommyGun
//******************************************************************************************

	StartTommyGun = gi.cvar ("StartTommyGun", "0", CVAR_SERVERINFO | CVAR_LATCH);

	if (StartTommyGun->value < 1)
		StartTommyGun->value = 0;
	else
		StartTommyGun->value = 1;

//******************************************************************************************
//StartHMG - If you start with the HMG
//******************************************************************************************

	StartHMG = gi.cvar ("StartHMG", "0", CVAR_SERVERINFO | CVAR_LATCH);

	if (StartHMG->value < 1)
		StartHMG->value = 0;
	else
		StartHMG->value = 1;

//******************************************************************************************
//StartGL - If you start with the Grenade Launcher
//******************************************************************************************

	StartGL = gi.cvar ("StartGL", "0", CVAR_SERVERINFO | CVAR_LATCH);

	if (StartGL->value < 1)
		StartGL->value = 0;
	else
		StartGL->value = 1;

//******************************************************************************************
//StartRL - If you start with the Rocket Launcher
//******************************************************************************************

	StartRL = gi.cvar ("StartRL", "0", CVAR_SERVERINFO | CVAR_LATCH);

	if (StartRL->value < 1)
		StartRL->value = 0;
	else
		StartRL->value = 1;

//******************************************************************************************
//StartFlamer - If you start with the FlameThrower
//******************************************************************************************

	StartFlameThrower = gi.cvar ("StartFlameThrower", "0", CVAR_SERVERINFO | CVAR_LATCH);

	if (StartFlameThrower->value < 1)
		StartFlameThrower->value = 0;
	else
		StartFlameThrower->value = 1;

//******************************************************************************************
//StartPistolLoaded - If you start with the Pistol Loaded
//******************************************************************************************

	StartPistolLoaded = gi.cvar ("StartPistolLoaded", "1", CVAR_SERVERINFO | CVAR_LATCH);

	if (StartPistolLoaded->value < 1)
		StartPistolLoaded->value = 0;
	else
		StartPistolLoaded->value = 1;


//******************************************************************************************
//StartShotgunLoaded - If you start with the Shotgun loaded
//******************************************************************************************

	StartShotgunLoaded = gi.cvar ("StartShotgunLoaded", "0", CVAR_SERVERINFO | CVAR_LATCH);

	if (StartShotgunLoaded->value < 1)
		StartShotgunLoaded->value = 0;
	else
		StartShotgunLoaded->value = 1;

//******************************************************************************************
//StartTommyGunLoaded - If you start with the TommyGunLoaded
//******************************************************************************************

	StartTommyGunLoaded = gi.cvar ("StartTommyGunLoaded", "0", CVAR_SERVERINFO | CVAR_LATCH);

	if (StartTommyGunLoaded->value < 1)
		StartTommyGunLoaded->value = 0;
	else
		StartTommyGunLoaded->value = 1;

//******************************************************************************************
//StartHMGLoaded - If you start with the HMG Loaded
//******************************************************************************************

	StartHMGLoaded = gi.cvar ("StartHMGLoaded", "0", CVAR_SERVERINFO | CVAR_LATCH);

	if (StartHMGLoaded->value < 1)
		StartHMGLoaded->value = 0;
	else
		StartHMGLoaded->value = 1;

//******************************************************************************************
//StartGL - If you start with the Grenade Launcher
//******************************************************************************************

	StartGLLoaded = gi.cvar ("StartGLLoaded", "0", CVAR_SERVERINFO | CVAR_LATCH);

	if (StartGLLoaded->value < 1)
		StartGLLoaded->value = 0;
	else
		StartGLLoaded->value = 1;

//******************************************************************************************
//StartRL - If you start with the Rocket Launcher
//******************************************************************************************

	StartRLLoaded = gi.cvar ("StartRLLoaded", "0", CVAR_SERVERINFO | CVAR_LATCH);

	if (StartRLLoaded->value < 1)
		StartRLLoaded->value = 0;
	else
		StartRLLoaded->value = 1;

//******************************************************************************************
//StartFlamer - If you start with the FlameThrower
//******************************************************************************************

	StartFlamerLoaded = gi.cvar ("StartFlamerLoaded", "0", CVAR_SERVERINFO | CVAR_LATCH);

	if (StartFlamerLoaded->value < 1)
		StartFlamerLoaded->value = 0;
	else
		StartFlamerLoaded->value = 1;

//******************************************************************************************
//ReplaceCrowbar - Don't spawn crowbar or respawn as something else
//******************************************************************************************

	ReplaceCrowbar = gi.cvar ("ReplaceCrowbar", "1", CVAR_SERVERINFO | CVAR_LATCH);

	if (ReplaceCrowbar->value < 1)
		ReplaceCrowbar->value = 0;
	else if (ReplaceCrowbar->value > 8)
				ReplaceCrowbar->value = 1;


//******************************************************************************************
//ReplacePistol - Don't spawn pistol or respawn as something else
//******************************************************************************************

	ReplacePistol = gi.cvar ("ReplacePistol", "2", CVAR_SERVERINFO | CVAR_LATCH);

	if (ReplacePistol->value < 1)
		ReplacePistol->value = 0;
	else if (ReplacePistol->value > 8)
				ReplacePistol->value = 2;

//******************************************************************************************
//ReplaceShotgun - Don't spawn shotgun or respawn as something else
//******************************************************************************************

	ReplaceShotgun = gi.cvar ("ReplaceShotgun", "3", CVAR_SERVERINFO | CVAR_LATCH);

	if (ReplaceShotgun->value < 1)
		ReplaceShotgun->value = 0;
	else if (ReplaceShotgun->value > 8)
				ReplaceShotgun->value = 3;


//******************************************************************************************
//ReplaceTommyGun - Don't spawn TommyGun or respawn as something else
//******************************************************************************************

	ReplaceTommyGun = gi.cvar ("ReplaceTommyGun", "4", CVAR_SERVERINFO | CVAR_LATCH);

	if (ReplaceTommyGun->value < 1)
		ReplaceTommyGun->value = 0;
	else if (ReplaceTommyGun->value > 8)
				ReplaceTommyGun->value = 4;


//******************************************************************************************
//ReplaceHMG - Don't spawn HMG or respawn as something else
//******************************************************************************************

	ReplaceHMG = gi.cvar ("ReplaceHMG", "5", CVAR_SERVERINFO | CVAR_LATCH);

	if (ReplaceHMG->value < 1)
		ReplaceHMG->value = 0;
	else if (ReplaceHMG->value > 8)
				ReplaceHMG->value = 5;


//******************************************************************************************
//ReplaceGL - Don't spawn GL or respawn as something else
//******************************************************************************************

	ReplaceGL = gi.cvar ("ReplaceGL", "6", CVAR_SERVERINFO | CVAR_LATCH);

	if (ReplaceGL->value < 1)
		ReplaceGL->value = 0;
	else if (ReplaceGL->value > 8)
				ReplaceGL->value = 6;



//******************************************************************************************
//ReplaceRL - Don't spawn RL or respawn as something else
//******************************************************************************************

	ReplaceRL = gi.cvar ("ReplaceRL", "7", CVAR_SERVERINFO | CVAR_LATCH);

	if (ReplaceRL->value < 1)
		ReplaceRL->value = 0;
	else if (ReplaceRL->value > 8)
				ReplaceRL->value = 7;


//******************************************************************************************
//ReplaceFlameThrower - Don't spawn Flamethrower or respawn as something else
//******************************************************************************************

	ReplaceFlameThrower = gi.cvar ("ReplaceFlameThrower", "8", CVAR_SERVERINFO | CVAR_LATCH);

	if (ReplaceFlameThrower->value < 1)
		ReplaceFlameThrower->value = 0;
	else if (ReplaceFlameThrower->value > 8)
				ReplaceFlameThrower->value = 8;


//******************************************************************************************
//ReplaceAllWeapons - Replace all the weapons with the item selected
//******************************************************************************************

	ReplaceAllWeapons = gi.cvar ("ReplaceAllWeapons", "-1", CVAR_SERVERINFO | CVAR_LATCH);

	if (ReplaceAllWeapons->value != -1)
	{
	if (ReplaceAllWeapons->value < 1)
		ReplaceAllWeapons->value = 0;
	else if (ReplaceAllWeapons->value > 8)
				ReplaceAllWeapons->value = 0;
	}
//******************************************************************************************
//ReplaceAllAmmo - Replace all the ammo with the item selected
//******************************************************************************************

	ReplaceAllAmmo= gi.cvar ("ReplaceAllAmmo", "0", CVAR_SERVERINFO | CVAR_LATCH);

	if (ReplaceAllAmmo->value < 1)
		ReplaceAllAmmo->value = 0;
	else if (ReplaceAllAmmo->value == 2)
		ReplaceAllAmmo->value = 0;
	else if (ReplaceAllAmmo->value > 8)
		ReplaceAllAmmo->value = 0;

//******************************************************************************************
//SetAllStartingArmourAs - Sets all armour to have this value
//******************************************************************************************

	SetAllStartingArmourAs= gi.cvar ("SetAllStartingArmourAs", "0", CVAR_SERVERINFO | CVAR_LATCH);

	if (SetAllStartingArmourAs->value != 0)
	{
		if (SetAllStartingArmourAs->value < 2)
			SetAllStartingArmourAs->value = 1;
		else if (SetAllStartingArmourAs->value > 999)
			SetAllStartingArmourAs->value = 999;
	}
//******************************************************************************************
//SetAllMaxArmourAs - Sets all armour to have this value
//******************************************************************************************

	SetAllMaxArmourAs= gi.cvar ("SetAllMaxArmourAs", "-1", CVAR_SERVERINFO | CVAR_LATCH);

if (SetAllMaxArmourAs->value !=-1)
{
	if (SetAllMaxArmourAs->value < 1)
		SetAllMaxArmourAs->value = 0;
	else if (SetAllMaxArmourAs->value > 999)
		SetAllMaxArmourAs->value = 999;
}
//******************************************************************************************
//ReplaceBullets - Don't spawn or respawn as something else
//******************************************************************************************

	ReplaceBullets = gi.cvar ("ReplaceBullets", "1", CVAR_SERVERINFO | CVAR_LATCH);

	if (ReplaceBullets->value < 1)
		ReplaceBullets->value = 0;
	else if (ReplaceBullets->value > 8)
				ReplaceBullets->value = 1;
	else if (ReplaceBullets->value == 4)
				ReplaceBullets->value = 1;	
	else if (ReplaceBullets->value == 1)
				ReplaceBullets->value = 1;
	
//******************************************************************************************
//ReplaceShells - Don't spawn or respawn as something else
//******************************************************************************************

	ReplaceShells = gi.cvar ("ReplaceShells", "3", CVAR_SERVERINFO | CVAR_LATCH);

	if (ReplaceShells->value < 1)
		ReplaceShells->value = 0;
	else if (ReplaceShells->value > 9)
				ReplaceShells->value = 3;

//******************************************************************************************
//ReplaceGas - Don't spawn or respawn as something else
//******************************************************************************************

	ReplaceGas = gi.cvar ("ReplaceGas", "8", CVAR_SERVERINFO | CVAR_LATCH);

	if (ReplaceGas->value < 1)
		ReplaceGas->value = 0;
	else if (ReplaceGas->value > 8)
				ReplaceGas->value = 8;


//******************************************************************************************
//ReplaceGrenades - Don't spawn or respawn as something else
//******************************************************************************************

	ReplaceGrenades= gi.cvar ("ReplaceGrenades", "6", CVAR_SERVERINFO | CVAR_LATCH);

	if (ReplaceGrenades->value < 1)
		ReplaceGrenades->value = 0;
	else if (ReplaceGrenades->value > 9)
				ReplaceGrenades->value = 6;

//******************************************************************************************
//ReplaceRockets - Don't spawn or respawn as something else
//******************************************************************************************

	ReplaceRockets= gi.cvar ("ReplaceRockets", "7", CVAR_SERVERINFO | CVAR_LATCH);

	if (ReplaceRockets->value < 1)
		ReplaceRockets->value = 0;
	else if (ReplaceRockets->value > 8)
				ReplaceRockets->value = 7;

//******************************************************************************************
//ReplaceCylinder - Don't spawn or respawn as something else
//******************************************************************************************

	ReplaceCylinder= gi.cvar ("ReplaceCylinder", "4", CVAR_SERVERINFO | CVAR_LATCH);

	if (ReplaceCylinder->value < 1)
		ReplaceCylinder->value = 0;
	else if (ReplaceCylinder->value > 8)
				ReplaceCylinder->value = 4;

//******************************************************************************************
//ReplaceHMGClip - Don't spawn or respawn as something else
//******************************************************************************************

	ReplaceHMGClip = gi.cvar ("ReplaceHMGClip", "5", CVAR_SERVERINFO | CVAR_LATCH);

	if (ReplaceHMGClip->value < 1)
		ReplaceHMGClip->value = 0;
	else if (ReplaceHMGClip->value > 8)
				ReplaceHMGClip->value = 5;

//******************************************************************************************
//PipeDamage - Value of damage
//******************************************************************************************

	PipeDamage = gi.cvar ("PipeDamage", "10", CVAR_SERVERINFO | CVAR_LATCH);

	if (PipeDamage->value < 1)
		PipeDamage->value = 0;
	else if (PipeDamage->value > 999)
				PipeDamage->value = 999;
//******************************************************************************************
//CrowbarDamage - Value of damage
//******************************************************************************************

	CrowbarDamage = gi.cvar ("CrowbarDamage", "50", CVAR_SERVERINFO | CVAR_LATCH);

	if (CrowbarDamage->value < 1)
		CrowbarDamage->value = 0;
	else if (CrowbarDamage->value > 999)
				CrowbarDamage->value = 999;

//******************************************************************************************
//PistolDamage - Value of damage
//******************************************************************************************

	PistolDamage = gi.cvar ("PistolDamage", "15", CVAR_SERVERINFO | CVAR_LATCH);

	if (PistolDamage->value < 1)
		PistolDamage->value = 0;
	else if (PistolDamage->value > 999)
				PistolDamage->value = 999;

//******************************************************************************************
//Silencer PistolDamage - Value of damage
//******************************************************************************************

	SpistolDamage = gi.cvar ("SpistolDamage", "15", CVAR_SERVERINFO | CVAR_LATCH);

	if (SpistolDamage->value < 1)
		SpistolDamage->value = 0;
	else if (SpistolDamage->value > 999)
				SpistolDamage->value = 999;

//******************************************************************************************
//Silencer Pistol Kick - Value of kick
//******************************************************************************************

	SpistolKick = gi.cvar ("SpistolKick", "2", CVAR_SERVERINFO | CVAR_LATCH);

	if (SpistolKick->value < 1)
		SpistolKick->value = 0;
	else if (SpistolKick->value > 999)
				SpistolKick->value = 999;

//******************************************************************************************
//ShotgunDamage - Value of damage
//******************************************************************************************

	ShotgunDamage = gi.cvar ("ShotgunDamage", "16", CVAR_SERVERINFO | CVAR_LATCH);

	if (ShotgunDamage->value < 1)
		ShotgunDamage->value = 0;
	else if (ShotgunDamage->value > 999)
				ShotgunDamage->value = 999;

//******************************************************************************************
//TommyGunDamage - Value of damage
//******************************************************************************************

	TommyGunDamage= gi.cvar ("TommyGunDamage", "14", CVAR_SERVERINFO | CVAR_LATCH);

	if (TommyGunDamage->value < 1)
		TommyGunDamage->value = 0;
	else if (TommyGunDamage->value > 999)
				TommyGunDamage->value = 999;


//******************************************************************************************
//HMGDamage - Value of damage
//******************************************************************************************

	HMGDamage= gi.cvar ("HMGDamage", "50", CVAR_SERVERINFO | CVAR_LATCH);

	if (HMGDamage->value < 1)
		HMGDamage->value = 0;
	else if (HMGDamage->value > 999)
				HMGDamage->value = 999;


//******************************************************************************************
//GrenadeDamage - Value of damage
//******************************************************************************************

	GrenadeDamage= gi.cvar ("GrenadeDamage", "125", CVAR_SERVERINFO | CVAR_LATCH);

	if (GrenadeDamage->value < 1)
		GrenadeDamage->value = 0;
	else if (GrenadeDamage->value > 999)
				GrenadeDamage->value = 999;

//******************************************************************************************
//GrenadeSplashRange - Value of damage
//******************************************************************************************

	GrenadeSplashRange= gi.cvar ("GrenadeSplashRange", "165", CVAR_SERVERINFO | CVAR_LATCH);

	if (GrenadeSplashRange->value < 1)
		GrenadeSplashRange->value = 0;
	else if (GrenadeSplashRange->value > 999)
				GrenadeSplashRange->value = 999;
//******************************************************************************************
//GrenadeFuseTimer - How long before the grenade explodes
//******************************************************************************************

	GrenadeFuseTimer= gi.cvar ("GrenadeFuseTimer", "2.0", CVAR_SERVERINFO | CVAR_LATCH);

	if (GrenadeFuseTimer->value < 1)
		GrenadeFuseTimer->value = 0;
	else if (GrenadeFuseTimer->value > 30)
				GrenadeFuseTimer->value = 30;

//******************************************************************************************
//RocketDamage - Value of damage
//******************************************************************************************

	RocketDamage= gi.cvar ("RocketDamage", "100", CVAR_SERVERINFO | CVAR_LATCH);

	if (RocketDamage->value < 1)
		RocketDamage->value = 0;
	else if (RocketDamage->value > 999)
				RocketDamage->value = 999;

//******************************************************************************************
//RocketSplashDamage - Value of splash range 
//******************************************************************************************

	RocketSplashDamage= gi.cvar ("RocketSplashDamage", "120", CVAR_SERVERINFO | CVAR_LATCH);

	if (RocketSplashDamage->value < 1)
		RocketSplashDamage->value = 0;
	else if (RocketSplashDamage->value > 999)
				RocketSplashDamage->value = 999;

//******************************************************************************************
//RocketSplashRadius - Value of splash radius 
//******************************************************************************************

	RocketSplashRadius= gi.cvar ("RocketSplashRadius", "180", CVAR_SERVERINFO | CVAR_LATCH);

	if (RocketSplashRadius->value < 1)
		RocketSplashRadius->value = 0;
	else if (RocketSplashRadius->value > 999)
				RocketSplashRadius->value= 999;
//******************************************************************************************
//RocketTrail - Whether the rocket trail is visible
//******************************************************************************************

	RocketTrail= gi.cvar ("RocketTrail", "1", CVAR_SERVERINFO | CVAR_LATCH);

	if (RocketTrail->value < 1)
		RocketTrail->value = 0;
	else if (RocketTrail->value > 1)
				RocketTrail->value = 1;


//******************************************************************************************
//RocketSpeed - What Speed the rocket travels at
//******************************************************************************************

	RocketSpeed= gi.cvar ("RocketSpeed", "900", CVAR_SERVERINFO | CVAR_LATCH);

	if (RocketSpeed->value < 100)
		RocketSpeed->value = 100;
	else if (RocketSpeed->value > 5000)
				RocketSpeed->value = 5000;



//******************************************************************************************
//FlameDamage - Value of damage
//******************************************************************************************

	FlameDamage= gi.cvar ("FlameDamage", "2", CVAR_SERVERINFO | CVAR_LATCH);

	if (FlameDamage->value < 1)
		FlameDamage->value = 0;
	else if (FlameDamage->value > 999)
				FlameDamage->value = 999;

//******************************************************************************************
//PipeKick - Value of kick
//******************************************************************************************

	PipeKick = gi.cvar ("PipeKick", "2", CVAR_SERVERINFO | CVAR_LATCH);

	if (PipeKick->value < 1)
		PipeKick->value = 0;
	else if (PipeKick->value > 999)
				PipeKick->value = 999;
//******************************************************************************************
//CrowbarKick - Value of Kick
//******************************************************************************************

	CrowbarKick = gi.cvar ("CrowbarKick", "2", CVAR_SERVERINFO | CVAR_LATCH);

	if (CrowbarKick->value < 1)
		CrowbarKick->value = 0;
	else if (CrowbarKick->value > 999)
				CrowbarKick->value = 999;

//******************************************************************************************
//PistolKick - Value of Kick
//******************************************************************************************

	PistolKick = gi.cvar ("PistolKick", "2", CVAR_SERVERINFO | CVAR_LATCH);

	if (PistolKick->value < 1)
		PistolKick->value = 0;
	else if (PistolKick->value > 999)
				PistolKick->value = 999;

//******************************************************************************************
//ShotgunKick - Value of Kick
//******************************************************************************************

	ShotgunKick = gi.cvar ("ShotgunKick", "50", CVAR_SERVERINFO | CVAR_LATCH);

	if (ShotgunKick->value < 1)
		ShotgunKick->value = 0;
	else if (ShotgunKick->value > 999)
				ShotgunKick->value = 999;

//******************************************************************************************
//TommyGunKick - Value of Kick
//******************************************************************************************

	TommyGunKick= gi.cvar ("TommyGunKick", "2", CVAR_SERVERINFO | CVAR_LATCH);

	if (TommyGunKick->value < 1)
		TommyGunKick->value = 0;
	else if (TommyGunKick->value > 999)
				TommyGunKick->value = 999;


//******************************************************************************************
//HMGKick - Value of Kick
//******************************************************************************************

	HMGKick= gi.cvar ("HMGKick", "50", CVAR_SERVERINFO | CVAR_LATCH);

	if (HMGKick->value < 1)
		HMGKick->value = 0;
	else if (HMGKick->value > 999)
				HMGKick->value = 999;


//******************************************************************************************
//FlameKick - Value of Kick
//******************************************************************************************

	FlameKick= gi.cvar ("FlameKick", "0", CVAR_SERVERINFO | CVAR_LATCH);

	if (FlameKick->value < 1)
		FlameKick->value = 0;
	else if (FlameKick->value > 999)
				FlameKick->value = 999;

//******************************************************************************************
//LightHelmet - Value of Light Helmet
//******************************************************************************************

	LightHelmet = gi.cvar ("LightHelmet", "25", CVAR_SERVERINFO | CVAR_LATCH);

	if (LightHelmet->value < 1)
		LightHelmet->value = 0;
	else if (LightHelmet->value > 999)
				LightHelmet->value = 999;

//******************************************************************************************
//HeavyHelmet - Value of Heavy Helmet
//******************************************************************************************

	HeavyHelmet = gi.cvar ("HeavyHelmet", "50", CVAR_SERVERINFO | CVAR_LATCH);

	if (HeavyHelmet->value < 1)
		HeavyHelmet->value = 0;
	else if (HeavyHelmet->value > 999)
				HeavyHelmet->value = 999;

//******************************************************************************************
//LightJacket - Value of Light Jacket
//******************************************************************************************

	LightJacket = gi.cvar ("LightJacket", "25", CVAR_SERVERINFO | CVAR_LATCH);

	if (LightJacket->value < 1)
		LightJacket->value = 0;
	else if (LightJacket->value > 999)
				LightJacket->value = 999;

//******************************************************************************************
//HeavyJacket - Value of Heavy Jacket
//******************************************************************************************

	HeavyJacket = gi.cvar ("HeavyJacket", "50", CVAR_SERVERINFO | CVAR_LATCH);

	if (HeavyJacket->value < 1)
		HeavyJacket->value = 0;
	else if (HeavyJacket->value > 999)
				HeavyJacket->value = 999;

//******************************************************************************************
//LightLeg - Value of Light Leg Armour
//******************************************************************************************

	LightLeg = gi.cvar ("LightLeg", "25", CVAR_SERVERINFO | CVAR_LATCH);

	if (LightLeg->value < 1)
		LightLeg->value = 0;
	else if (LightLeg->value > 999)
				LightLeg->value = 999;

//******************************************************************************************
//HeavyLeg - Value of Heavy Leg Armour
//******************************************************************************************

	HeavyLeg = gi.cvar ("HeavyLeg", "50", CVAR_SERVERINFO | CVAR_LATCH);

	if (HeavyLeg->value < 1)
		HeavyLeg->value = 0;
	else if (HeavyLeg->value > 999)
				HeavyLeg->value = 999;


//******************************************************************************************
//RespawnArmour - How Often Armour respawns
//******************************************************************************************

	RespawnArmour = gi.cvar ("RespawnArmour", "45", CVAR_SERVERINFO | CVAR_LATCH);

	if (RespawnArmour->value < 1)
		RespawnArmour->value = 0;
	else if (RespawnArmour->value > 999)
				RespawnArmour->value = 999;

	
//******************************************************************************************
//DontSpawnArmour - Whether or not to initially spawn the armour
//******************************************************************************************

	DontSpawnArmour = gi.cvar ("DontSpawnArmour ", "0", CVAR_SERVERINFO | CVAR_LATCH);
	
	if (DontSpawnArmour->value < 1)
		DontSpawnArmour->value = 0;
	else if (DontSpawnArmour->value > 0)
				DontSpawnArmour->value = 1;
 

//******************************************************************************************
//SmallHealth - size of small health pack
//******************************************************************************************

	SmallHealth = gi.cvar ("SmallHealth", "15", CVAR_SERVERINFO | CVAR_LATCH);

	if (SmallHealth->value < 1)
		SmallHealth->value = 0;
	else if (SmallHealth->value > 999)
				SmallHealth->value = 999;

//******************************************************************************************
//LargeHealth - size of large health pack
//******************************************************************************************

	LargeHealth = gi.cvar ("LargeHealth", "25", CVAR_SERVERINFO | CVAR_LATCH);

	if (LargeHealth->value < 1)
		LargeHealth->value = 0;
	else if (LargeHealth->value > 999)
				LargeHealth->value = 999;

//******************************************************************************************
//RespawnHealth - How Often Armour respawns
//******************************************************************************************

	RespawnHealth = gi.cvar ("RespawnHealth", "30", CVAR_SERVERINFO | CVAR_LATCH);

	if (RespawnHealth->value < 1)
		RespawnHealth->value = 0;
	else if (RespawnHealth->value > 999)
				RespawnHealth->value = 999;

//******************************************************************************************
//DontSpawnHealth - Whether or not to spawn health initially
//******************************************************************************************

	DontSpawnHealth = gi.cvar ("DontSpawnHealth", "0", CVAR_SERVERINFO | CVAR_LATCH);
	if (DontSpawnHealth->value >1)
		DontSpawnHealth->value =1;
	if (DontSpawnHealth->value < 0)
		DontSpawnHealth->value = 0;
//******************************************************************************************
//RespawnAmmo - How Often Ammo respawns
//******************************************************************************************

	RespawnAmmo = gi.cvar ("RespawnAmmo", "30", CVAR_SERVERINFO | CVAR_LATCH);

	if (RespawnAmmo->value < 1)
		RespawnAmmo->value = 0;
	else if (RespawnAmmo ->value > 999)
				RespawnAmmo->value = 999;

//******************************************************************************************
//DontSpawnAmmo - Whether or not to initially spawn ammo
//******************************************************************************************

	DontSpawnAmmo= gi.cvar ("DontSpawnAmmo", "0", CVAR_SERVERINFO | CVAR_LATCH);

	if (DontSpawnAmmo->value < 1)
		DontSpawnAmmo->value = 0;
	else if (DontSpawnAmmo->value > 1)
				DontSpawnAmmo->value = 1;


//******************************************************************************************
//RespawnPistolMods - How Often the pistol mods respawn
//******************************************************************************************

	RespawnPistolMods= gi.cvar ("RespawnPistolMods", "30", CVAR_SERVERINFO | CVAR_LATCH);

	if (RespawnPistolMods->value < 1)
		RespawnPistolMods->value = 0;
	else if (RespawnPistolMods->value > 999)
				RespawnPistolMods->value = 999;
//******************************************************************************************
//DontSpawnPistolMods - Whether or not to spawn the pistol mods
//******************************************************************************************

	DontSpawnPistolMods= gi.cvar ("DontSpawnPistolMods", "1", CVAR_SERVERINFO | CVAR_LATCH);

	if (DontSpawnPistolMods->value < 1)
		DontSpawnPistolMods->value = 0;
	else if (DontSpawnPistolMods->value > 1)
				DontSpawnPistolMods->value = 1;

//******************************************************************************************
//RespawnPack - How Often Ammo Pack respawns
//******************************************************************************************
 
	RespawnPack= gi.cvar ("RespawnPack", "30", CVAR_SERVERINFO | CVAR_LATCH);

	if (RespawnPack->value < 1)
		RespawnPack->value = 0;
	else if (RespawnPack->value > 999)
				RespawnPack->value = 999;
//******************************************************************************************
//DontSpawnPack - Whether or not to spawn the ammo pack initially
//******************************************************************************************
 
	DontSpawnPack = gi.cvar ("DontSpawnPack ", "1", CVAR_SERVERINFO | CVAR_LATCH);

	if (DontSpawnPack ->value < 1)
		DontSpawnPack ->value = 0;
	else if (DontSpawnPack ->value > 1)
				DontSpawnPack ->value = 1;


//******************************************************************************************
//RespawnBandolier - How Often The Bandolier respawns
//******************************************************************************************

	RespawnBandolier= gi.cvar ("RespawnBandolier", "30", CVAR_SERVERINFO | CVAR_LATCH);

	if (RespawnBandolier->value < 1)
		RespawnBandolier->value = 0;
	else if (RespawnBandolier->value > 999)
				RespawnBandolier->value = 999;

//******************************************************************************************
//DontSpawnBandolier - Whether or not to spawn the bandolier initially
//******************************************************************************************

	DontSpawnBandolier= gi.cvar ("DontSpawnBandolier", "1", CVAR_SERVERINFO | CVAR_LATCH);

	if (DontSpawnBandolier->value < 1)
		DontSpawnBandolier->value = 0;
	else if (DontSpawnBandolier->value > 1)
				DontSpawnBandolier->value = 1;

//******************************************************************************************
//StartUsingThisWeapon - Which weapon you are using when you start
//******************************************************************************************

	StartUsingThisWeapon= gi.cvar ("StartUsingThisWeapon", "2", CVAR_SERVERINFO | CVAR_LATCH);

	if (StartUsingThisWeapon->value < 1)
		StartUsingThisWeapon->value = 0;
	else if (StartUsingThisWeapon->value > 8)
				StartUsingThisWeapon->value = 2;

//******************************************************************************************
//Wad - The value of a cash roll
//******************************************************************************************

	Wad= gi.cvar ("Wad", "10", CVAR_SERVERINFO | CVAR_LATCH);

	if (Wad->value < 1)
		Wad->value = 1;
	else if (Wad->value > 999)
				Wad->value = 999;

//******************************************************************************************
//Swag - The value of a cash bag
//******************************************************************************************

	Swag= gi.cvar ("Swag", "25", CVAR_SERVERINFO | CVAR_LATCH);

	if (Swag->value < 1)
		Swag->value = 1;
	else if (Swag->value > 999)
				Swag->value = 999;

//******************************************************************************************
//MaxCashPlayer - The most cash a player can carry (wads)
//******************************************************************************************

	MaxCashPlayer= gi.cvar ("MaxCashPlayer", "150", CVAR_SERVERINFO | CVAR_LATCH);

	if (MaxCashPlayer->value < 1)
		MaxCashPlayer->value = 1;
	else if (MaxCashPlayer->value > 999)
				MaxCashPlayer->value = 999;

//******************************************************************************************
//MaxBagCashPlayer - The most cash a player can carry (bags & safe jobs)
//******************************************************************************************

	MaxBagCashPlayer= gi.cvar ("MaxBagCashPlayer", "150", CVAR_SERVERINFO | CVAR_LATCH);

	if (MaxBagCashPlayer->value < 1)
		MaxBagCashPlayer->value = 1;
	else if (MaxBagCashPlayer->value > 999)
				MaxBagCashPlayer->value = 999;
//******************************************************************************************
//MaxTimeAtSafe - How long a player can stay near their own safe before being subject to friendly fire
//******************************************************************************************

	MaxTimeAtSafe= gi.cvar ("MaxTimeAtSafe", "8.0", CVAR_SERVERINFO | CVAR_LATCH);

	if (MaxTimeAtSafe->value < 0)
		MaxTimeAtSafe->value = 0;
	else if (MaxTimeAtSafe->value > 99)
				MaxTimeAtSafe->value = 99;

//******************************************************************************************
//SafeCloseDistance - How close a play must be before being subject to the maxtimeatsafe variable
//******************************************************************************************

	SafeCloseDistance= gi.cvar ("SafeCloseDistance", "128", CVAR_SERVERINFO | CVAR_LATCH);

	if (SafeCloseDistance->value < 1)
		SafeCloseDistance->value = 1;
	else if (SafeCloseDistance->value > 999)
				SafeCloseDistance->value = 999;

	
//******************************************************************************************
//DragonsStartingCash - The value of a cash bag
//******************************************************************************************

	DragonsStartingCash= gi.cvar ("DragonsStartingCash", "0", CVAR_SERVERINFO | CVAR_LATCH);

	if (DragonsStartingCash->value < 1)
		DragonsStartingCash->value = 0;
	else if (DragonsStartingCash->value > 9999)
				DragonsStartingCash->value = 9999;

//******************************************************************************************
//NikkisStartingCash - The value of a cash bag
//******************************************************************************************

	NikkisStartingCash= gi.cvar ("NikkisStartingCash", "0", CVAR_SERVERINFO | CVAR_LATCH);

	if (NikkisStartingCash->value < 1)
		NikkisStartingCash->value = 0;
	else if (NikkisStartingCash->value > 9999)
				NikkisStartingCash->value = 9999;

//******************************************************************************************
//TripleRockets - Fire 3 rockets at once
//******************************************************************************************

	TripleRockets= gi.cvar ("TripleRockets", "0", CVAR_SERVERINFO | CVAR_LATCH);

	if (TripleRockets->value < 1)
		TripleRockets->value = 0;
	else if (TripleRockets->value > 0)
				TripleRockets->value = 1;

//******************************************************************************************
//TripleRocketsCost - Cost to Fire 3 rockets at once
//******************************************************************************************

	TripleRocketsCost= gi.cvar ("TripleRocketsCost", "3", CVAR_SERVERINFO | CVAR_LATCH);

	if (TripleRocketsCost->value < 1)
		TripleRocketsCost->value = 1;
	else if (TripleRocketsCost->value > 5)
				TripleRocketsCost->value = 5;
	
//******************************************************************************************
//TroxSelected - Whether mrox is on or not - always set to zero at joining.
//******************************************************************************************

	TroxSelected= gi.cvar ("TroxSelected", "1", CVAR_SERVERINFO | CVAR_LATCH);

	if (TroxSelected->value < 1)
		TroxSelected->value = 0;
	else if (TroxSelected->value > 1)
				TroxSelected->value = 1;
//******************************************************************************************
//dmboots - whether they are on or not - hidden value. always 0 at initialising
//******************************************************************************************

	dmboots= gi.cvar ("dmboots", "0", CVAR_SERVERINFO | CVAR_LATCH);

//******************************************************************************************
//AntiGravityBoots- whether boots are allowed or not- hidden value. always 0 at initialising
//******************************************************************************************

	AntiGravityBoots= gi.cvar ("AntiGravityBoots", "0", CVAR_SERVERINFO | CVAR_LATCH);

//******************************************************************************************
//PlayerSpeed - Pace of the game
//******************************************************************************************

	PlayerSpeed= gi.cvar ("PlayerSpeed", "9", CVAR_SERVERINFO | CVAR_LATCH);

//******************************************************************************************
//ModifyGameSpeed - Pace of the game
//******************************************************************************************

	ModifyGameSpeed = gi.cvar ("ModifyGameSpeed", "0", CVAR_SERVERINFO | CVAR_LATCH);

	if (ModifyGameSpeed->value < 1)
		ModifyGameSpeed->value = 0;
	else if (ModifyGameSpeed->value > 0)
				ModifyGameSpeed->value = 1;

	

//ARENA VARIABLES


		CrowbarArena= gi.cvar ("CrowbarArena", "0", CVAR_SERVERINFO | CVAR_LATCH);
		PistolArena= gi.cvar ("PistolArena", "0", CVAR_SERVERINFO | CVAR_LATCH);
		ShotgunArena= gi.cvar ("ShotgunArena", "0", CVAR_SERVERINFO | CVAR_LATCH);
		TommygunArena= gi.cvar ("TommygunArena", "0", CVAR_SERVERINFO | CVAR_LATCH);
		HMGArena= gi.cvar ("HMGArena", "0", CVAR_SERVERINFO | CVAR_LATCH);
		GLArena= gi.cvar ("GLArena", "0", CVAR_SERVERINFO | CVAR_LATCH);
		RLArena= gi.cvar ("RLArena", "0", CVAR_SERVERINFO | CVAR_LATCH);
		FlamerArena= gi.cvar ("FlamerArena", "0", CVAR_SERVERINFO | CVAR_LATCH);
		SilencerArena= gi.cvar ("SilencerArena", "0", CVAR_SERVERINFO | CVAR_LATCH);
		SoundThePipes= gi.cvar ("SoundThePipes", "0", CVAR_SERVERINFO | CVAR_LATCH);


//******************************************************************************************
// WCJ - End of DM Mutator Variable definitions
//******************************************************************************************

	// RAFAEL
//	marines = gi.cvar ("marines", "0", CVAR_ARCHIVE);

	// change anytime vars
	dmflags = gi.cvar ("dmflags", "0", CVAR_SERVERINFO|CVAR_ARCHIVE);

//fraglimit set per map.... changed from 0 to 30	
	fraglimit = gi.cvar ("fraglimit", "30", CVAR_SERVERINFO);

// changed timelimit default from 0??? to 30
	timelimit = gi.cvar ("timelimit", "30", CVAR_SERVERINFO);
// changed cashlimit default from 0 to 2000
	cashlimit = gi.cvar ("cashlimit", "2000", CVAR_SERVERINFO);

	password = gi.cvar ("password", "", CVAR_USERINFO);
	filterban = gi.cvar ("filterban", "1", 0);

	g_select_empty = gi.cvar ("g_select_empty", "0", CVAR_ARCHIVE);

	run_pitch = gi.cvar ("run_pitch", "0.002", 0);
	run_roll = gi.cvar ("run_roll", "0.005", 0);
	bob_up  = gi.cvar ("bob_up", "0.005", 0);
	bob_pitch = gi.cvar ("bob_pitch", "0.002", 0);
	bob_roll = gi.cvar ("bob_roll", "0.002", 0);

	// flood control
	flood_msgs = gi.cvar ("flood_msgs", "4", 0);
	flood_persecond = gi.cvar ("flood_persecond", "4", 0);
	flood_waitdelay = gi.cvar ("flood_waitdelay", "10", 0);

// Ridah, new cvar's
	developer = gi.cvar ("developer", "0", 0);

	maxrate = gi.cvar ("maxrate", "25000", CVAR_SERVERINFO);

	ai_debug_memory = gi.cvar ("ai_debug_memory", "0", 0);

	g_vehicle_test = gi.cvar ("g_vehicle_test", "0", CVAR_LATCH);	// Enables Hovercars for all players

	dm_locational_damage = gi.cvar ("dm_locational_damage", "0", CVAR_SERVERINFO);

	showlights =  gi.cvar ("showlights", "0", 0);

	r_directional_lighting = gi.cvar ("r_directional_lighting", "1", CVAR_ARCHIVE);

	cl_captions = gi.cvar ("cl_captions", "0", CVAR_ARCHIVE);	// Ridah, disabled this by default, is that cool?

	sv_runscale = gi.cvar ("sv_runscale", "1.0", 0);	// only effective in Deathmatch

	burn_enabled	= gi.cvar("burn_enabled", "0", 0);
	burn_size		= gi.cvar("burn_size", "48", 0);
	burn_intensity	= gi.cvar("burn_intensity", "0.03", 0);
	burn_r			= gi.cvar("burn_r", "1.0", 0);
	burn_g			= gi.cvar("burn_g", "1.0", 0);
	burn_b			= gi.cvar("burn_b", "1.0", 0);

	timescale		= gi.cvar("timescale", "1.0", 0);

	teamplay		= gi.cvar("teamplay", "0", CVAR_LATCH|CVAR_SERVERINFO);
	g_cashspawndelay = gi.cvar("g_cashspawndelay", "5", CVAR_ARCHIVE|CVAR_LATCH);

	// this is only used for single player games
	cl_parental_lock = gi.cvar( "cl_parental_lock", "0", CVAR_NOSET);
	cl_parental_override = gi.cvar( "cl_parental_override", "0", CVAR_NOSET);

	dm_realmode = gi.cvar( "dm_realmode", "0", CVAR_LATCH|CVAR_SERVERINFO);
	
	g_mapcycle_file = gi.cvar( "g_mapcycle_file", "", 0);
// Ridah, done.

	// items
	InitItems ();

	Com_sprintf (game.helpmessage1, sizeof(game.helpmessage1), "");

	Com_sprintf (game.helpmessage2, sizeof(game.helpmessage2), "");

	// initialize all entities for this game
	game.maxentities = maxentities->value;
	g_edicts =  gi.TagMalloc (game.maxentities * sizeof(g_edicts[0]), TAG_GAME);
	globals.edicts = g_edicts;
	globals.max_edicts = game.maxentities;

	g_cast_memory = gi.TagMalloc (MAX_CHARACTERS * MAX_CHARACTERS * sizeof(cast_memory_t), TAG_GAME );
	memset( g_cast_memory, 0, MAX_CHARACTERS * MAX_CHARACTERS * sizeof(cast_memory_t) );

	g_cast_groups = gi.TagMalloc (MAX_CAST_GROUPS * sizeof(cast_group_t), TAG_GAME );
	memset( g_cast_groups, 0, MAX_CAST_GROUPS * sizeof(cast_group_t) );

	// initialize all clients for this game
	game.maxclients = maxclients->value;
	game.clients = gi.TagMalloc (game.maxclients * sizeof(game.clients[0]), TAG_GAME);
	globals.num_edicts = game.maxclients+1;
}

//=========================================================

void WriteField1 (FILE *f, field_t *field, byte *base)
{
	void		*p;
	int			len;
	int			index;

	if (field->flags & FFL_SPAWNTEMP)
		return;

	p = (void *)(base + field->ofs);
	switch (field->type)
	{
	case F_INT:
	case F_FLOAT:
	case F_ANGLEHACK:
	case F_VECTOR:
	case F_IGNORE:
		break;

	case F_LSTRING:
	case F_GSTRING:
		if ( *(char **)p )
			len = strlen(*(char **)p) + 1;
		else
			len = 0;
		*(int *)p = len;
		break;
	case F_EDICT:
		if ( *(edict_t **)p == NULL)
			index = -1;
		else
			index = *(edict_t **)p - g_edicts;
		*(int *)p = index;
		break;
	case F_CLIENT:
		if ( *(gclient_t **)p == NULL)
			index = -1;
		else
			index = *(gclient_t **)p - game.clients;
		*(int *)p = index;
		break;
	case F_ITEM:
		if ( *(edict_t **)p == NULL)
			index = -1;
		else
			index = *(gitem_t **)p - itemlist;
		*(int *)p = index;
		break;

	case F_CAST_MEMORY:
		if ( *(cast_memory_t **)p == NULL)
			index = -1;
		else
			index = *(cast_memory_t **)p - g_cast_memory;
		*(int *)p = index;
		break;

	//relative to code segment
	case F_FUNCTION:
		if (*(byte **)p == NULL)
			index = 0;
		else
			index = *(byte **)p - ((byte *)InitGame);
		*(int *)p = index;
		break;

	//relative to data segment
	case F_MMOVE:
		if (*(byte **)p == NULL)
			index = 0;
		else
			index = *(byte **)p - (byte *)&mmove_reloc;
		*(int *)p = index;
		break;

	default:
		gi.error ("WriteEdict: unknown field type");
	}
}


void WriteField2 (FILE *f, field_t *field, byte *base)
{
	int			len;
	void		*p;

	if (field->flags & FFL_SPAWNTEMP)
		return;

	p = (void *)(base + field->ofs);
	switch (field->type)
	{
	case F_LSTRING:
		if ( *(char **)p )
		{
			len = strlen(*(char **)p) + 1;
			fwrite (*(char **)p, len, 1, f);
		}
		break;
	}
}

void ReadField (FILE *f, field_t *field, byte *base)
{
	void		*p;
	int			len;
	int			index;

	if (field->flags & FFL_SPAWNTEMP)
		return;

	p = (void *)(base + field->ofs);
	switch (field->type)
	{
	case F_INT:
	case F_FLOAT:
	case F_ANGLEHACK:
	case F_VECTOR:
	case F_IGNORE:
		break;

	case F_LSTRING:
		len = *(int *)p;
		if (!len)
			*(char **)p = NULL;
		else
		{
			*(char **)p = gi.TagMalloc (len, TAG_LEVEL);
			fread (*(char **)p, len, 1, f);
		}
		break;
	case F_EDICT:
		index = *(int *)p;
		if ( index == -1 )
			*(edict_t **)p = NULL;
		else
			*(edict_t **)p = &g_edicts[index];
		break;
	case F_CLIENT:
		index = *(int *)p;
		if ( index == -1 )
			*(gclient_t **)p = NULL;
		else
			*(gclient_t **)p = &game.clients[index];
		break;
	case F_ITEM:
		index = *(int *)p;
		if ( index == -1 )
			*(gitem_t **)p = NULL;
		else
			*(gitem_t **)p = &itemlist[index];
		break;

	case F_CAST_MEMORY:
		index = *(int *)p;
		if ( index == -1 )
			*(cast_memory_t **)p = NULL;
		else
			*(cast_memory_t **)p = &g_cast_memory[index];
		break;

	//relative to code segment
	case F_FUNCTION:
		index = *(int *)p;
		if ( index == 0 )
			*(byte **)p = NULL;
		else
			*(byte **)p = ((byte *)InitGame) + index;
		break;

	//relative to data segment
	case F_MMOVE:
		index = *(int *)p;
		if (index == 0)
			*(byte **)p = NULL;
		else
			*(byte **)p = (byte *)&mmove_reloc + index;
		break;

	default:
		gi.error ("ReadEdict: unknown field type");
	}
}

//=========================================================

/*
==============
WriteClient

All pointer variables (except function pointers) must be handled specially.
==============
*/
void WriteClient (FILE *f, gclient_t *client)
{
	field_t		*field;
	gclient_t	temp;
	
	// all of the ints, floats, and vectors stay as they are
	temp = *client;

	// change the pointers to lengths or indexes
	for (field=clientfields ; field->name ; field++)
	{
		WriteField1 (f, field, (byte *)&temp);
	}

	// write the block
	fwrite (&temp, sizeof(temp), 1, f);

	// now write any allocated data following the edict
	for (field=clientfields ; field->name ; field++)
	{
		WriteField2 (f, field, (byte *)client);
	}
}

/*
==============
ReadClient

All pointer variables (except function pointers) must be handled specially.
==============
*/
void ReadClient (FILE *f, gclient_t *client)
{
	field_t		*field;

	fread (client, sizeof(*client), 1, f);

	for (field=clientfields ; field->name ; field++)
	{
		ReadField (f, field, (byte *)client);
	}
}

/*
============
WriteGame

This will be called whenever the game goes to a new level,
and when the user explicitly saves the game.

Game information include cross level data, like multi level
triggers, help computer info, and all client states.

A single player death will automatically restore from the
last save position.
============
*/
void WriteGame (char *filename, qboolean autosave)
{
	FILE	*f;
	int		i;
	char	str[16];

	if (!autosave)
		SaveClientData ();

	f = fopen (filename, "wb");
	if (!f)
		gi.error ("Couldn't open %s", filename);

	memset (str, 0, sizeof(str));
	strcpy (str, __DATE__);
	fwrite (str, sizeof(str), 1, f);

	game.autosaved = autosave;
	fwrite (&game, sizeof(game), 1, f);
	game.autosaved = false;

	for (i=0 ; i<game.maxclients ; i++)
		WriteClient (f, &game.clients[i]);

	fclose (f);
}

void ReadGame (char *filename)
{
	FILE	*f;
	int		i;
	char	str[16];

	gi.FreeTags (TAG_GAME);

	f = fopen (filename, "rb");
	if (!f)
		gi.error ("Couldn't open %s", filename);

	fread (str, sizeof(str), 1, f);
	if (strcmp (str, __DATE__))
	{
		fclose (f);
		gi.error ("Savegame from an older version.\n");
	}

	g_edicts =  gi.TagMalloc (game.maxentities * sizeof(g_edicts[0]), TAG_GAME);
	globals.edicts = g_edicts;

	g_cast_memory = gi.TagMalloc (MAX_CHARACTERS * MAX_CHARACTERS * sizeof(cast_memory_t), TAG_GAME );
	memset( g_cast_memory, 0, MAX_CHARACTERS * MAX_CHARACTERS * sizeof(cast_memory_t) );

	g_cast_groups = gi.TagMalloc (MAX_CAST_GROUPS * sizeof(cast_group_t), TAG_GAME );
	memset( g_cast_groups, 0, MAX_CAST_GROUPS * sizeof(cast_group_t) );

	fread (&game, sizeof(game), 1, f);
	game.clients = gi.TagMalloc (game.maxclients * sizeof(game.clients[0]), TAG_GAME);
	for (i=0 ; i<game.maxclients ; i++)
		ReadClient (f, &game.clients[i]);

	fclose (f);
}

//==========================================================


/*
==============
WriteEdict

All pointer variables (except function pointers) must be handled specially.
==============
*/
void WriteEdict (FILE *f, edict_t *ent)
{
	field_t		*field;
	edict_t		temp;

	// all of the ints, floats, and vectors stay as they are
	temp = *ent;

	// change the pointers to lengths or indexes
	for (field=fields ; field->name ; field++)
	{
		WriteField1 (f, field, (byte *)&temp);
	}

	temp.last_voice = NULL;	// this can't be saved

	// write the block
	fwrite (&temp, sizeof(temp), 1, f);

	// now write any allocated data following the edict
	for (field=fields ; field->name ; field++)
	{
		WriteField2 (f, field, (byte *)ent);
	}

}

/*
==============
WriteLevelLocals

All pointer variables (except function pointers) must be handled specially.
==============
*/
void WriteLevelLocals (FILE *f)
{
	field_t		*field;
	level_locals_t		temp;

	// all of the ints, floats, and vectors stay as they are
	temp = level;

	// change the pointers to lengths or indexes
	for (field=levelfields ; field->name ; field++)
	{
		WriteField1 (f, field, (byte *)&temp);
	}

	// write the block
	fwrite (&temp, sizeof(temp), 1, f);

	// now write any allocated data following the edict
	for (field=levelfields ; field->name ; field++)
	{
		WriteField2 (f, field, (byte *)&level);
	}
}

/*
==============
WriteCastMemories
==============
*/
void WriteCastMemories (FILE *f)
{
	field_t		*field;
	cast_memory_t	temp;
	int			i, j, out;

	for (i=0; i<MAX_CHARACTERS; i++)
	{
		for (j=0; j<MAX_CHARACTERS; j++)
		{
			if (!g_cast_memory[i * MAX_CHARACTERS + j].cast_ent)
				continue;

			memcpy( &temp, &(g_cast_memory[i * MAX_CHARACTERS + j]), sizeof(cast_memory_t) );

			// write the index number
			out = i * MAX_CHARACTERS + j;
			fwrite (&out, sizeof(out), 1, f);

			// change the pointers to lengths or indexes
			for (field=castmemoryfields ; field->name ; field++)
			{
				WriteField1 (f, field, (byte *)(&temp));
			}

			// write the block
			fwrite (&temp, sizeof(cast_memory_t), 1, f);

			// now write any allocated data following the edict
			for (field=castmemoryfields ; field->name ; field++)
			{
				WriteField2 (f, field, (byte *)(&(g_cast_memory[i * MAX_CHARACTERS + j])));
			}

		}
	}

	out = -1;
	fwrite (&out, sizeof(out), 1, f);
}

/*
==============
WriteCastGroups
==============
*/
void WriteCastGroups (FILE *f)
{
	// write the block
	fwrite (g_cast_groups, sizeof(cast_group_t) * MAX_CAST_GROUPS, 1, f);
}

/*
==============
ReadCastGroups
==============
*/
void ReadCastGroups (FILE *f)
{
	// write the block
	fread (g_cast_groups, sizeof(cast_group_t) * MAX_CAST_GROUPS, 1, f);
}


/*
==============
ReadEdict

All pointer variables (except function pointers) must be handled specially.
==============
*/
void ReadEdict (FILE *f, edict_t *ent)
{
	field_t		*field;

	// Ridah, save the object_bounds
	int		object_bounds[MAX_MODEL_PARTS][MAX_MODELPART_OBJECTS];
	int		i;

	for (i=0; i<MAX_MODEL_PARTS; i++)
		memcpy( object_bounds[i], ent->s.model_parts[i].object_bounds, sizeof(int)*MAX_MODELPART_OBJECTS );

	fread (ent, sizeof(*ent), 1, f);

	for (field=fields ; field->name ; field++)
	{
		ReadField (f, field, (byte *)ent);
	}

	// Ridah, restore object_bounds
	for (i=0; i<MAX_MODEL_PARTS; i++)
		memcpy( ent->s.model_parts[i].object_bounds, object_bounds[i], sizeof(int)*MAX_MODELPART_OBJECTS );
}

/*
==============
ReadLevelLocals

All pointer variables (except function pointers) must be handled specially.
==============
*/
void ReadLevelLocals (FILE *f)
{
	field_t		*field;
	
	int			i, j;

	fread (&level, sizeof(level), 1, f);

	for (field=levelfields ; field->name ; field++)
	{
		ReadField (f, field, (byte *)&level);
	}

	// setup the global cast memory
	for (i=0; i<MAX_CHARACTERS; i++)
	{
		for (j=0; j<MAX_CHARACTERS; j++)
		{
			if (g_cast_memory[i * MAX_CHARACTERS + j].cast_ent)
			{
				level.global_cast_memory[i][j] = &(g_cast_memory[i * MAX_CHARACTERS + j]);
			}
		}
	}
}

/*
==============
ReadCastMemories

All pointer variables (except function pointers) must be handled specially.
==============
*/
void ReadCastMemories (FILE *f)
{
	field_t		*field;
	int			i;

	while (1)
	{
		fread (&i, sizeof(i), 1, f);

		if (i < 0)
			break;

		fread (&(g_cast_memory[i]), sizeof(cast_memory_t), 1, f);

		for (field=castmemoryfields ; field->name ; field++)
		{
			ReadField (f, field, (byte *)&(g_cast_memory[i]) );
		}
	}
}

/*
=================
WriteLevel

=================
*/
void WriteLevel (char *filename)
{
	int		i;
	edict_t	*ent;
	FILE	*f;
	void	*base;
// BEGIN:	Xatrix/Ridah/Navigator/18-apr-1998
	active_node_data_t *node_data;
// END:		Xatrix/Ridah/Navigator/18-apr-1998

	f = fopen (filename, "wb");
	if (!f)
		gi.error ("Couldn't open %s", filename);

// BEGIN:	Xatrix/Ridah/Navigator/18-apr-1998
	// don't save the nav data
	node_data = level.node_data;
	level.node_data = NULL;
// END:		Xatrix/Ridah/Navigator/18-apr-1998

	// write out edict size for checking
	i = sizeof(edict_t);
	fwrite (&i, sizeof(i), 1, f);

	// write out a function pointer for checking
	base = (void *)InitGame;
	fwrite (&base, sizeof(base), 1, f);

	// write the team data
	WriteCastGroups (f);

	// write out the cast_memory data
	WriteCastMemories (f);

	// write out level_locals_t
	WriteLevelLocals (f);

	// write out all the entities
	for (i=0 ; i<globals.num_edicts ; i++)
	{
		ent = &g_edicts[i];
		if (!ent->inuse)
			continue;
		fwrite (&i, sizeof(i), 1, f);
		WriteEdict (f, ent);
	}
	i = -1;
	fwrite (&i, sizeof(i), 1, f);


	// write the cast_memory data


	fclose (f);

// BEGIN:	Xatrix/Ridah/Navigator/18-apr-1998
	// restore the nav data
	level.node_data = node_data;
// END:		Xatrix/Ridah/Navigator/18-apr-1998

}


/*
=================
ReadLevel

SpawnEntities will allready have been called on the
level the same way it was when the level was saved.

That is necessary to get the baselines
set up identically.

The server will have cleared all of the world links before
calling ReadLevel.

No clients are connected yet.
=================
*/

qboolean	changing_levels=false;

void ReadLevel (char *filename)
{
	int		entnum;
	FILE	*f;
	int		i;
	void	*base;
	edict_t	*ent;

// BEGIN:	Xatrix/Ridah/Navigator/18-apr-1998
	// restore nav data
	active_node_data_t *node_data;
// END:		Xatrix/Ridah/Navigator/18-apr-1998

	f = fopen (filename, "rb");
	if (!f)
		gi.error ("Couldn't open %s", filename);

	// free any dynamic memory allocated by loading the level
	// base state
	gi.FreeTags (TAG_LEVEL);

	gi.ClearObjectBoundsCached();	// make sure we wipe the cached list

	num_object_bounds = 0;
	memset (g_objbnds, 0, sizeof(g_objbnds));

	// wipe all the entities
	memset (g_edicts, 0, game.maxentities*sizeof(g_edicts[0]));
	globals.num_edicts = maxclients->value+1;

	memset( g_cast_memory, 0, MAX_CHARACTERS * MAX_CHARACTERS * sizeof(cast_memory_t) );
	memset( g_cast_groups, 0, MAX_CAST_GROUPS * sizeof(cast_group_t) );

	// check edict size
	fread (&i, sizeof(i), 1, f);
	if (i != sizeof(edict_t))
	{
		fclose (f);
		gi.error ("ReadLevel: mismatched edict size");
	}

	// check function pointer base address
	fread (&base, sizeof(base), 1, f);
#ifdef _WIN32
	if (base != (void *)InitGame)
	{
		fclose (f);
		gi.error ("ReadLevel: function pointers have moved");
	}
#else
	gi.dprintf("Function offsets %d\n", ((byte *)base) - ((byte *)InitGame));
#endif

// BEGIN:	Xatrix/Ridah/Navigator/18-apr-1998
	// save nav data
	node_data = level.node_data;
	level.node_data = NULL;
// END:		Xatrix/Ridah/Navigator/18-apr-1998

	// read the team data
	ReadCastGroups (f);

	// load the cast memories
	ReadCastMemories (f);

	// load the level locals
	ReadLevelLocals (f);

// BEGIN:	Xatrix/Ridah/Navigator/18-apr-1998
	// restore nav data
	level.node_data = node_data;

	// upon changing levels, the nav data is cleared, but when loading or starting a new game,
	// the node data is loading in SpawnEntities()
	if (!node_data)
	{
		level.node_data = gi.TagMalloc (sizeof (active_node_data_t), TAG_GAME);
		NAV_ReadActiveNodes (level.node_data, level.mapname);
	}
// END:		Xatrix/Ridah/Navigator/18-apr-1998

	// load all the entities
	while (1)
	{

		if (fread (&entnum, sizeof(entnum), 1, f) != 1)
		{
			fclose (f);
			gi.error ("ReadLevel: failed to read entnum");
		}
		if (entnum == -1)
			break;
		if (entnum >= globals.num_edicts)
			globals.num_edicts = entnum+1;

		ent = &g_edicts[entnum];

		ReadEdict (f, ent);

		// Ridah, restore the object bounds data
		for (i=0; i<MAX_MODEL_PARTS; i++)
		{
			if (ent->s.model_parts[i].objectbounds_filename)
			{
				gi.GetObjectBounds( ent->s.model_parts[i].objectbounds_filename, &ent->s.model_parts[i] );
			}
		}

// BEGIN:	Xatrix/Ridah/Navigator/16-apr-1998
		// Init Navigational data for this entity
		ent->active_node_data = level.node_data;
		ent->nav_data.cache_node = -1;
		ent->nav_build_data = NULL;		// make sure it's null, since it'll be set in ClientConnect() anyway
// END:		Xatrix/Ridah/Navigator/16-apr-1998

		// let the server rebuild world links for this ent
		memset (&ent->area, 0, sizeof(ent->area));
		gi.linkentity (ent);
	}

	fclose (f);

	// mark all clients as unconnected
	for (i=0 ; i<maxclients->value ; i++)
	{
		ent = &g_edicts[i+1];
		ent->client = game.clients + i;
		ent->client->pers.connected = false;
	}

	// init the characters array (we'll set it manually
	memset( level.characters, 0, 4 * MAX_CHARACTERS );

	// always set the client first
	level.characters[0] = &g_edicts[1];

	// do any load time things at this point
	for (i=0 ; i<globals.num_edicts ; i++)
	{
		ent = &g_edicts[i];

		if (!ent->inuse)
			continue;

		// set the character array
		if (((ent->svflags & SVF_MONSTER) && (ent->character_index > 0)) || ent->client)
		{
			level.characters[ent->character_index] = ent;
		}

		// fire any cross-level triggers
		if (ent->classname)
			if (strcmp(ent->classname, "target_crosslevel_target") == 0)
				ent->nextthink = level.time + ent->delay;

		// JOSEPH 19-JAN-99
		// Restore rotating train absmax absmin
		if (!strcmp(ent->classname, "func_train_rotating"))
		{
			float		max, v;
			int			i;

			max = 0;
			for (i=0 ; i<3 ; i++)
			{
				v =fabs(ent->mins[i]);
				if (v > max)
					max = v;
				v =fabs(ent->maxs[i]);
				if (v > max)
					max = v;
			}
			for (i=0 ; i<3 ; i++)
			{
				ent->absmin[i] = ent->s.origin[i] - max;
				ent->absmax[i] = ent->s.origin[i] + max;
			}
		}
		// END JOSEPH		

		// Ridah, restore nextthink times for rain/snow clouds so they send the message to clients (this is ugly, but should work)
		if (	!strcmp( ent->classname, "elements_raincloud" )
			||	!strcmp( ent->classname, "elements_snowcloud" ))
		{
			ent->nextthink = level.time + (10 * FRAMETIME);
		}
	}


	if (changing_levels)
	{
		int	i;
		edict_t	*e;

		// kill any followers
		for (i=0; i<level.num_characters; i++)
		{
			e = level.characters[i];

			if (!e)
				continue;

			if (e->flags & FL_FOLLOWING)
			{
				// vanish!
				AI_UnloadCastMemory( e );
				G_FreeEdict( e );
			}
		}

	}
	else	// clear any following flags
	{
		int	i;
		edict_t	*e;

		// kill any followers
		for (i=0; i<level.num_characters; i++)
		{
			e = level.characters[i];

			if (!e)
				continue;

			e->flags &= ~FL_FOLLOWING;
		}
	}

}
